import { WebPlugin } from "@capacitor/core";
export class NetworkPluginElectron extends WebPlugin {
    constructor() {
        super({
            name: "Network",
            platforms: ["electron"],
        });
        this.listenerFunction = null;
    }
    getStatus() {
        return new Promise((resolve, reject) => {
            if (!window.navigator) {
                reject("Network info not available");
                return;
            }
            let connected = window.navigator.onLine;
            let connection = window.navigator.connection ||
                window.navigator.mozConnection ||
                window.navigator.webkitConnection;
            let connectionType = "wifi";
            if (connection) {
                connectionType = connection.type;
            }
            resolve({
                connected: connected,
                connectionType: connected ? connectionType : "none",
            });
        });
    }
    addListener(eventName, listenerFunc) {
        let thisRef = this;
        let connection = window.navigator.connection ||
            window.navigator.mozConnection ||
            window.navigator.webkitConnection;
        let connectionType = "wifi";
        if (connection) {
            connectionType = connection.type;
        }
        let onlineBindFunc = listenerFunc.bind(thisRef, {
            connected: true,
            connectionType: connectionType,
        });
        let offlineBindFunc = listenerFunc.bind(thisRef, {
            connected: false,
            connectionType: "none",
        });
        if (eventName.localeCompare("networkStatusChange") === 0) {
            window.addEventListener("online", onlineBindFunc);
            window.addEventListener("offline", offlineBindFunc);
            return {
                remove: () => {
                    window.removeEventListener("online", onlineBindFunc);
                    window.removeEventListener("offline", offlineBindFunc);
                },
            };
        }
    }
}
const Network = new NetworkPluginElectron();
export { Network };
//# sourceMappingURL=network.js.map